<?php
/**
 * Prince VIP System - Profile AJAX
 */
require_once __DIR__ . '/../config/database.php';
if (!isLoggedIn()) { echo json_encode(['success' => false, 'message' => 'غير مصرح']); exit; }

$db = getDB();
$action = $_POST['action'] ?? '';

if ($action === 'update') {
    $db->prepare("UPDATE users SET full_name=?, email=?, phone=? WHERE id=?")
       ->execute([clean($_POST['full_name']), clean($_POST['email'] ?? ''), clean($_POST['phone'] ?? ''), $_SESSION['user_id']]);
    $_SESSION['full_name'] = clean($_POST['full_name']);
    echo json_encode(['success' => true, 'message' => 'تم تحديث المعلومات']);
} elseif ($action === 'password') {
    $user = $db->prepare("SELECT password FROM users WHERE id = ?");
    $user->execute([$_SESSION['user_id']]);
    $u = $user->fetch();
    
    if (!password_verify($_POST['current_password'], $u['password'])) {
        echo json_encode(['success' => false, 'message' => 'كلمة المرور الحالية غير صحيحة']);
        exit;
    }
    if ($_POST['new_password'] !== $_POST['confirm_password']) {
        echo json_encode(['success' => false, 'message' => 'كلمة المرور الجديدة لا تتطابق']);
        exit;
    }
    if (strlen($_POST['new_password']) < 6) {
        echo json_encode(['success' => false, 'message' => 'كلمة المرور يجب أن تكون 6 أحرف على الأقل']);
        exit;
    }
    
    $db->prepare("UPDATE users SET password=? WHERE id=?")->execute([password_hash($_POST['new_password'], PASSWORD_DEFAULT), $_SESSION['user_id']]);
    echo json_encode(['success' => true, 'message' => 'تم تغيير كلمة المرور بنجاح']);
} else {
    echo json_encode(['success' => false, 'message' => 'إجراء غير معروف']);
}
