<?php
/**
 * Prince VIP System - Settings AJAX Handler
 */
require_once __DIR__ . '/../config/database.php';
if (!isLoggedIn() || !isAdmin()) { echo json_encode(['success' => false, 'message' => 'غير مصرح']); exit; }

$db = getDB();
$action = $_POST['action'] ?? '';

switch ($action) {
    case 'create':
        $category = clean($_POST['category'] ?? '');
        $value = clean($_POST['option_value'] ?? '');
        $order = (int)($_POST['sort_order'] ?? 0);
        
        if (empty($value)) {
            echo json_encode(['success' => false, 'message' => 'يرجى إدخال القيمة']);
            exit;
        }
        
        $db->prepare("INSERT INTO settings_options (category, option_value, sort_order) VALUES (?,?,?)")
           ->execute([$category, $value, $order]);
        echo json_encode(['success' => true, 'message' => 'تم إضافة الخيار بنجاح']);
        break;
    
    case 'update':
        $id = (int)($_POST['id'] ?? 0);
        $db->prepare("UPDATE settings_options SET option_value=?, sort_order=? WHERE id=?")
           ->execute([clean($_POST['option_value']), (int)$_POST['sort_order'], $id]);
        echo json_encode(['success' => true, 'message' => 'تم تحديث الخيار']);
        break;
    
    case 'toggle':
        $id = (int)($_POST['id'] ?? 0);
        $isActive = (int)($_POST['is_active'] ?? 0);
        $db->prepare("UPDATE settings_options SET is_active=? WHERE id=?")->execute([$isActive, $id]);
        echo json_encode(['success' => true, 'message' => $isActive ? 'تم تفعيل الخيار' : 'تم تعطيل الخيار']);
        break;
    
    default:
        echo json_encode(['success' => false, 'message' => 'إجراء غير معروف']);
}
