<?php
/**
 * Prince VIP System - Clients Management
 * إدارة العملاء
 */
$pageTitle = 'العملاء';
require_once 'includes/header.php';
$db = getDB();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1"><i class="fas fa-users text-primary me-2"></i>إدارة العملاء</h4>
        <p class="text-muted small mb-0">عرض وإدارة العملاء المسجلين</p>
    </div>
    <button class="btn btn-gold" data-bs-toggle="modal" data-bs-target="#addClientModal">
        <i class="fas fa-plus me-1"></i> عميل جديد
    </button>
</div>

<!-- بحث -->
<div class="content-card">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <input type="text" id="searchClients" class="form-control" placeholder="🔍 بحث بالاسم أو رقم الهوية أو الجوال...">
            </div>
            <div class="col-md-2">
                <button id="btnSearchClients" class="btn btn-gold w-100"><i class="fas fa-search me-1"></i> بحث</button>
            </div>
        </div>
    </div>
</div>

<!-- جدول العملاء -->
<div class="content-card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>الاسم الكامل</th>
                        <th>رقم الهوية</th>
                        <th>رقم الجوال</th>
                        <th>عدد العقود</th>
                        <th>تاريخ التسجيل</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
                <tbody id="clientsBody"></tbody>
            </table>
        </div>
        <div id="clientsPagination" class="d-flex justify-content-center p-3"></div>
    </div>
</div>

<!-- مودال إضافة عميل -->
<div class="modal fade" id="addClientModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-user-plus text-primary me-2"></i>إضافة عميل جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="addClientForm">
                    <div class="form-group">
                        <label>الاسم الرباعي الكامل <span class="required">*</span></label>
                        <input type="text" name="full_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>رقم الهوية الوطنية <span class="required">*</span></label>
                        <input type="text" name="id_number" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>رقم الجوال <span class="required">*</span></label>
                        <input type="text" name="phone" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control">
                    </div>
                    <div class="form-group mb-0">
                        <label>العنوان</label>
                        <textarea name="address" class="form-control" rows="2"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" id="saveClient" class="btn btn-gold">حفظ العميل</button>
            </div>
        </div>
    </div>
</div>

<!-- مودال تعديل -->
<div class="modal fade" id="editClientModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit text-primary me-2"></i>تعديل بيانات العميل</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="editClientForm">
                    <input type="hidden" name="client_id" id="editClientId">
                    <div class="form-group">
                        <label>الاسم الكامل <span class="required">*</span></label>
                        <input type="text" name="full_name" id="editFullName" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>رقم الهوية <span class="required">*</span></label>
                        <input type="text" name="id_number" id="editIdNumber" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>رقم الجوال <span class="required">*</span></label>
                        <input type="text" name="phone" id="editPhone" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>البريد الإلكتروني</label>
                        <input type="email" name="email" id="editEmail" class="form-control">
                    </div>
                    <div class="form-group mb-0">
                        <label>العنوان</label>
                        <textarea name="address" id="editAddress" class="form-control" rows="2"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" id="updateClient" class="btn btn-gold">تحديث</button>
            </div>
        </div>
    </div>
</div>

<?php
$extraJS = <<<'JS'
<script>
$(document).ready(function() {
    loadClients();
    
    $('#btnSearchClients, #searchClients').on('keyup click', debounce(function() { loadClients(); }, 400));
    
    $('#saveClient').on('click', function() {
        const data = $('#addClientForm').serialize() + '&action=create';
        ajaxRequest('ajax/clients.php', data, function(r) {
            if (r.success) {
                showAlert(r.message, 'success');
                bootstrap.Modal.getInstance('#addClientModal').hide();
                $('#addClientForm')[0].reset();
                loadClients();
            } else showAlert(r.message, 'danger');
        });
    });
    
    $('#updateClient').on('click', function() {
        const data = $('#editClientForm').serialize() + '&action=update';
        ajaxRequest('ajax/clients.php', data, function(r) {
            if (r.success) {
                showAlert(r.message, 'success');
                bootstrap.Modal.getInstance('#editClientModal').hide();
                loadClients();
            } else showAlert(r.message, 'danger');
        });
    });
});

function loadClients(page = 1) {
    ajaxRequest('ajax/clients.php', {action:'list', search: $('#searchClients').val(), page: page}, function(r) {
        if (r.success) {
            let html = '';
            if (r.data.length === 0) {
                html = '<tr><td colspan="7" class="text-center text-muted py-4">لا يوجد عملاء</td></tr>';
            } else {
                r.data.forEach(function(c, i) {
                    html += '<tr><td>' + ((page-1)*15 + i + 1) + '</td>';
                    html += '<td class="fw-bold">' + c.full_name + '</td>';
                    html += '<td>' + c.id_number + '</td>';
                    html += '<td>' + c.phone + '</td>';
                    html += '<td><span class="badge bg-primary">' + c.contracts_count + '</span></td>';
                    html += '<td class="text-muted small">' + c.created_at + '</td>';
                    html += '<td><button class="btn btn-sm btn-outline-gold me-1" onclick="editClient(' + c.id + ',\'' + c.full_name + '\',\'' + c.id_number + '\',\'' + c.phone + '\',\'' + (c.email||'') + '\',\'' + (c.address||'') + '\')"><i class="fas fa-edit"></i></button></td>';
                    html += '</tr>';
                });
            }
            $('#clientsBody').html(html);
        }
    });
}

function editClient(id, name, idNum, phone, email, address) {
    $('#editClientId').val(id);
    $('#editFullName').val(name);
    $('#editIdNumber').val(idNum);
    $('#editPhone').val(phone);
    $('#editEmail').val(email);
    $('#editAddress').val(address);
    new bootstrap.Modal('#editClientModal').show();
}
</script>
JS;

require_once 'includes/footer.php';
?>
