<?php
/**
 * Prince VIP System - Database Configuration
 * إعدادات قاعدة البيانات
 */

define('DB_HOST', 'localhost');
define('DB_NAME', 'prince_vip');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// اتصال قاعدة البيانات
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
            ]);
        } catch (PDOException $e) {
            die("خطأ في الاتصال بقاعدة البيانات: " . $e->getMessage());
        }
    }
    return $pdo;
}

// إعدادات النظام العامة
define('SITE_NAME', 'Prince VIP System');
define('SITE_URL', '/PrinceVIP/');
define('UPLOAD_DIR', __DIR__ . '/../uploads/');
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'pdf']);

// بدء الجلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// دالة حماية الإدخال
function clean($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// دالة التحقق من تسجيل الدخول
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// دالة التحقق من صلاحية المدير
function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

// دالة إعادة التوجيه
function redirect($url) {
    header("Location: $url");
    exit();
}

// دالة توليد رقم العقد
function generateContractNumber($db) {
    $stmt = $db->query("SELECT MAX(CAST(contract_number AS UNSIGNED)) as max_num FROM contracts");
    $result = $stmt->fetch();
    $nextNum = ($result['max_num'] ?? 3130000) + 1;
    return str_pad($nextNum, 7, '0', STR_PAD_LEFT);
}

// دالة رفع الملفات
function uploadFile($file, $subDir = '') {
    if (!isset($file['tmp_name']) || empty($file['tmp_name'])) {
        return null;
    }
    
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ALLOWED_EXTENSIONS)) {
        return ['error' => 'نوع الملف غير مسموح'];
    }
    
    if ($file['size'] > MAX_FILE_SIZE) {
        return ['error' => 'حجم الملف يتجاوز الحد المسموح'];
    }
    
    $uploadPath = UPLOAD_DIR . $subDir;
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }
    
    $newName = uniqid() . '_' . time() . '.' . $ext;
    $fullPath = $uploadPath . '/' . $newName;
    
    if (move_uploaded_file($file['tmp_name'], $fullPath)) {
        return ['success' => true, 'filename' => ($subDir ? $subDir . '/' : '') . $newName];
    }
    
    return ['error' => 'فشل في رفع الملف'];
}
