<?php
/**
 * Prince VIP System - New Contract
 * إنشاء عقد جديد
 */
$pageTitle = 'عقد جديد';
require_once 'includes/header.php';

$db = getDB();

// جلب خيارات القوائم المنسدلة
$plateTypes = $db->query("SELECT * FROM settings_options WHERE category = 'plate_type' AND is_active = 1 ORDER BY sort_order")->fetchAll();
$classifications = $db->query("SELECT * FROM settings_options WHERE category = 'classification' AND is_active = 1 ORDER BY sort_order")->fetchAll();
$licenseTypes = $db->query("SELECT * FROM settings_options WHERE category = 'license_type' AND is_active = 1 ORDER BY sort_order")->fetchAll();
$carTypes = $db->query("SELECT * FROM settings_options WHERE category = 'car_type' AND is_active = 1 ORDER BY sort_order")->fetchAll();
$usageTypes = $db->query("SELECT * FROM settings_options WHERE category = 'usage_type' AND is_active = 1 ORDER BY sort_order")->fetchAll();
$insuranceTypes = $db->query("SELECT * FROM settings_options WHERE category = 'insurance_type' AND is_active = 1 ORDER BY sort_order")->fetchAll();

// جلب العملاء المسجلين
if (isAdmin()) {
    $clients = $db->query("SELECT id, full_name, id_number, phone FROM clients ORDER BY full_name")->fetchAll();
} else {
    $stmtClients = $db->prepare("SELECT id, full_name, id_number, phone FROM clients WHERE created_by = ? ORDER BY full_name");
    $stmtClients->execute([$_SESSION['user_id']]);
    $clients = $stmtClients->fetchAll();
}

$contractNumber = generateContractNumber($db);

// سنوات الإنتاج
$currentYear = (int)date('Y');
$startYear = 1980;
$endYear = $currentYear + 5;
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1"><i class="fas fa-plus-circle text-primary me-2"></i>إنشاء عقد جديد</h4>
        <p class="text-muted small mb-0">رقم العقد: <strong><?= $contractNumber ?></strong></p>
    </div>
    <a href="contracts.php" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-right me-1"></i> العودة للعقود
    </a>
</div>

<form id="contractForm" enctype="multipart/form-data">
    <input type="hidden" name="contract_number" value="<?= $contractNumber ?>">
    
    <div class="row">
        <!-- القسم الأيسر: بيانات العميل والمركبة -->
        <div class="col-lg-8">
            <!-- معلومات أساسية -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-id-card text-primary"></i> المعلومات الأساسية</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم العقد</label>
                                <input type="text" class="form-control" value="<?= $contractNumber ?>" readonly style="background:#f8f9fa;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم البطاقة</label>
                                <input type="text" name="card_number" class="form-control" placeholder="أدخل رقم البطاقة">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- معلومات العميل -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-user text-success"></i> معلومات العميل</h5>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>اختيار العميل</label>
                        <div class="d-flex gap-3 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="client_type" id="existingClient" value="existing" checked>
                                <label class="form-check-label" for="existingClient">عميل مسجل</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="client_type" id="newClient" value="new">
                                <label class="form-check-label" for="newClient">عميل جديد</label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- اختيار عميل موجود -->
                    <div id="existingClientSection">
                        <div class="form-group">
                            <label>البحث عن عميل <span class="required">*</span></label>
                            <select name="client_id" id="clientSelect" class="form-select">
                                <option value="">-- اختر العميل --</option>
                                <?php foreach ($clients as $client): ?>
                                <option value="<?= $client['id'] ?>" data-phone="<?= clean($client['phone']) ?>" data-id-number="<?= clean($client['id_number']) ?>">
                                    <?= clean($client['full_name']) ?> - <?= clean($client['id_number']) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <!-- إضافة عميل جديد -->
                    <div id="newClientSection" style="display:none;">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>الاسم الرباعي الكامل <span class="required">*</span></label>
                                    <input type="text" name="client_name" class="form-control" placeholder="الاسم الأول الأب الجد العائلة">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>رقم الهوية الوطنية <span class="required">*</span></label>
                                    <input type="text" name="client_id_number" class="form-control" placeholder="رقم الهوية">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>رقم الجوال <span class="required">*</span></label>
                                    <input type="text" name="client_phone" class="form-control" placeholder="05xxxxxxxx">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- تفاصيل المركبة -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-car text-info"></i> تفاصيل المركبة</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع نمرة السيارة <span class="required">*</span></label>
                                <select name="plate_type" class="form-select" required>
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($plateTypes as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>التصنيف</label>
                                <select name="classification" class="form-select">
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($classifications as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم السيارة <span class="required">*</span></label>
                                <input type="text" name="car_number" class="form-control" placeholder="رقم لوحة السيارة" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع الترخيص</label>
                                <select name="license_type" class="form-select">
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($licenseTypes as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع السيارة <span class="required">*</span></label>
                                <select name="car_type" class="form-select" required>
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($carTypes as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>لون السيارة</label>
                                <input type="text" name="car_color" class="form-control" placeholder="لون السيارة">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>سنة الإنتاج</label>
                                <select name="production_year" class="form-select">
                                    <option value="">-- اختر --</option>
                                    <?php for ($y = $endYear; $y >= $startYear; $y--): ?>
                                    <option value="<?= $y ?>"><?= $y ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>صفة الاستخدام</label>
                                <select name="usage_type" class="form-select">
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($usageTypes as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع التأمين</label>
                                <select name="insurance_type" class="form-select">
                                    <option value="">-- اختر --</option>
                                    <?php foreach ($insuranceTypes as $opt): ?>
                                    <option value="<?= clean($opt['option_value']) ?>"><?= clean($opt['option_value']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم الشاصي (17 حرف)</label>
                                <input type="text" name="chassis_number" class="form-control" placeholder="رقم الشاصي" maxlength="17">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- تواريخ الاشتراك -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-calendar-alt text-warning"></i> تواريخ الاشتراك</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ بدء الاشتراك <span class="required">*</span></label>
                                <input type="date" name="start_date" id="startDate" class="form-control" value="<?= date('Y-m-d') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ انتهاء الاشتراك <span class="required">*</span></label>
                                <input type="date" name="end_date" id="endDate" class="form-control" value="<?= date('Y-m-d', strtotime('+1 year')) ?>" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- ملاحظات -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-sticky-note text-secondary"></i> ملاحظات</h5>
                </div>
                <div class="card-body">
                    <div class="form-group mb-0">
                        <textarea name="notes" class="form-control" rows="3" placeholder="أي ملاحظات إضافية على العقد..."></textarea>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- القسم الأيمن: المرفقات والأزرار -->
        <div class="col-lg-4">
            <!-- المرفقات -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-paperclip text-danger"></i> المرفقات</h5>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>مرفق العقد الأول</label>
                        <input type="file" name="attachment1" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
                        <small class="text-muted">JPG, PNG, PDF - حتى 10MB</small>
                    </div>
                    <div class="form-group">
                        <label>مرفق العقد الثاني</label>
                        <input type="file" name="attachment2" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
                    </div>
                    <div class="form-group mb-0">
                        <label>مرفق العقد الثالث</label>
                        <input type="file" name="attachment3" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
                    </div>
                </div>
            </div>
            
            <!-- أزرار الحفظ -->
            <div class="content-card">
                <div class="card-body">
                    <button type="button" id="saveDraft" class="btn btn-outline-secondary w-100 mb-3 py-3">
                        <i class="fas fa-save me-1"></i> حفظ كمسودة
                    </button>
                    <button type="button" id="saveComplete" class="btn btn-gold w-100 py-3">
                        <i class="fas fa-check-circle me-1"></i> إنهاء العقد وتصدير البوليصة
                    </button>
                </div>
            </div>
            
            <!-- ملخص -->
            <div class="content-card">
                <div class="card-header">
                    <h5><i class="fas fa-info-circle text-info"></i> ملخص</h5>
                </div>
                <div class="card-body">
                    <div class="small text-muted">
                        <div class="d-flex justify-content-between mb-2">
                            <span>رقم العقد:</span>
                            <strong><?= $contractNumber ?></strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>الوكيل:</span>
                            <strong><?= clean($_SESSION['full_name']) ?></strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>التاريخ:</span>
                            <strong><?= date('Y/m/d') ?></strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<?php
$extraJS = <<<'JS'
<script>
$(document).ready(function() {
    // تبديل نوع العميل
    $('input[name="client_type"]').on('change', function() {
        if ($(this).val() === 'existing') {
            $('#existingClientSection').show();
            $('#newClientSection').hide();
        } else {
            $('#existingClientSection').hide();
            $('#newClientSection').show();
        }
    });
    
    // تحديث تاريخ الانتهاء عند تغيير تاريخ البدء
    $('#startDate').on('change', function() {
        const startDate = new Date($(this).val());
        startDate.setFullYear(startDate.getFullYear() + 1);
        const endDate = startDate.toISOString().split('T')[0];
        $('#endDate').val(endDate);
    });
    
    // حفظ كمسودة
    $('#saveDraft').on('click', function() {
        submitContract('draft');
    });
    
    // إنهاء العقد
    $('#saveComplete').on('click', function() {
        submitContract('pending');
    });
    
    function submitContract(status) {
        const formData = new FormData($('#contractForm')[0]);
        formData.append('status', status);
        formData.append('action', 'create');
        
        // التحقق من البيانات المطلوبة
        const clientType = $('input[name="client_type"]:checked').val();
        if (clientType === 'existing' && !$('#clientSelect').val()) {
            showAlert('يرجى اختيار العميل', 'warning');
            return;
        }
        if (clientType === 'new') {
            if (!$('input[name="client_name"]').val() || !$('input[name="client_id_number"]').val() || !$('input[name="client_phone"]').val()) {
                showAlert('يرجى إكمال بيانات العميل الجديد', 'warning');
                return;
            }
        }
        
        if (!$('select[name="plate_type"]').val()) {
            showAlert('يرجى اختيار نوع النمرة', 'warning');
            return;
        }
        if (!$('input[name="car_number"]').val()) {
            showAlert('يرجى إدخال رقم السيارة', 'warning');
            return;
        }
        
        ajaxUpload('ajax/contracts.php', formData, function(response) {
            if (response.success) {
                showAlert(response.message, 'success');
                if (status === 'pending' && response.contract_id) {
                    setTimeout(function() {
                        window.location.href = 'contract_view.php?id=' + response.contract_id;
                    }, 1500);
                } else {
                    setTimeout(function() {
                        window.location.href = 'contracts.php';
                    }, 1500);
                }
            } else {
                showAlert(response.message, 'danger');
            }
        });
    }
});
</script>
JS;

require_once 'includes/footer.php';
?>
