<?php
require_once __DIR__ . '/../config/database.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$db = getDB();

// جلب عدد الإشعارات غير المقروءة
$notifStmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
$notifStmt->execute([$_SESSION['user_id']]);
$unreadNotifs = $notifStmt->fetchColumn();

// جلب آخر الإشعارات
$notifsStmt = $db->prepare("SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC LIMIT 10");
$notifsStmt->execute([$_SESSION['user_id']]);
$notifications = $notifsStmt->fetchAll();

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$userInitial = mb_substr($_SESSION['full_name'], 0, 1, 'UTF-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($pageTitle) ? $pageTitle . ' - ' : '' ?>Prince VIP System</title>
    
    <!-- Bootstrap 5 RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Tajawal Font -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800;900&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>

<!-- Sidebar Overlay -->
<div class="sidebar-overlay"></div>

<!-- Sidebar -->
<aside class="sidebar">
    <div class="sidebar-brand">
        <img src="images/logo.png" alt="Prince VIP">
        <h5>Prince VIP</h5>
        <small>PRINCE VIP SYSTEM</small>
    </div>
    
    <p class="sidebar-section">الرئيسية</p>
    <ul class="sidebar-menu">
        <li>
            <a href="dashboard.php" class="<?= $currentPage == 'dashboard' ? 'active' : '' ?>">
                <i class="fas fa-th-large"></i>
                <span>لوحة التحكم</span>
            </a>
        </li>
        <li>
            <a href="notifications.php" class="<?= $currentPage == 'notifications' ? 'active' : '' ?>">
                <i class="fas fa-bell"></i>
                <span>الإشعارات</span>
                <?php if ($unreadNotifs > 0): ?>
                <span class="badge bg-danger"><?= $unreadNotifs ?></span>
                <?php endif; ?>
            </a>
        </li>
    </ul>
    
    <p class="sidebar-section">العمليات</p>
    <ul class="sidebar-menu">
        <li>
            <a href="contracts.php" class="<?= $currentPage == 'contracts' ? 'active' : '' ?>">
                <i class="fas fa-file-contract"></i>
                <span>العقود</span>
            </a>
        </li>
        <li>
            <a href="contract_new.php" class="<?= $currentPage == 'contract_new' ? 'active' : '' ?>">
                <i class="fas fa-plus-circle"></i>
                <span>عقد جديد</span>
            </a>
        </li>
        <li>
            <a href="clients.php" class="<?= $currentPage == 'clients' ? 'active' : '' ?>">
                <i class="fas fa-users"></i>
                <span>العملاء</span>
            </a>
        </li>
    </ul>
    
    <?php if (isAdmin()): ?>
    <p class="sidebar-section">الإدارة</p>
    <ul class="sidebar-menu">
        <li>
            <a href="agents.php" class="<?= $currentPage == 'agents' ? 'active' : '' ?>">
                <i class="fas fa-user-tie"></i>
                <span>الوكلاء</span>
            </a>
        </li>
        <li>
            <a href="reports.php" class="<?= $currentPage == 'reports' ? 'active' : '' ?>">
                <i class="fas fa-chart-bar"></i>
                <span>التقارير</span>
            </a>
        </li>
        <li>
            <a href="settings.php" class="<?= $currentPage == 'settings' ? 'active' : '' ?>">
                <i class="fas fa-cog"></i>
                <span>الإعدادات</span>
            </a>
        </li>
    </ul>
    <?php endif; ?>
    
    <p class="sidebar-section">الحساب</p>
    <ul class="sidebar-menu">
        <li>
            <a href="profile.php" class="<?= $currentPage == 'profile' ? 'active' : '' ?>">
                <i class="fas fa-user-circle"></i>
                <span>الملف الشخصي</span>
            </a>
        </li>
        <li>
            <a href="logout.php" style="color:rgba(255,255,255,0.5);">
                <i class="fas fa-sign-out-alt"></i>
                <span>تسجيل الخروج</span>
            </a>
        </li>
    </ul>
</aside>

<!-- Top Navbar -->
<nav class="top-navbar">
    <div class="d-flex align-items-center gap-3">
        <button class="sidebar-toggle" onclick="$('.sidebar').toggleClass('show');$('.sidebar-overlay').toggleClass('show');">
            <i class="fas fa-bars"></i>
        </button>
        <div class="navbar-search">
            <input type="text" id="globalSearch" placeholder="🔍 بحث عن عقد، عميل...">
            <button class="search-btn"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <div class="navbar-actions">
        <a href="contract_new.php" class="nav-icon" data-bs-toggle="tooltip" title="عقد جديد">
            <i class="fas fa-plus"></i>
        </a>
        <div class="position-relative">
            <button class="nav-icon notification-btn">
                <i class="fas fa-bell"></i>
                <?php if ($unreadNotifs > 0): ?>
                <span class="badge bg-danger rounded-pill"><?= $unreadNotifs ?></span>
                <?php endif; ?>
            </button>
            <div class="notification-dropdown">
                <div class="n-header">
                    <strong>الإشعارات</strong>
                    <?php if ($unreadNotifs > 0): ?>
                    <a href="ajax/notifications.php?action=markAllRead" class="text-primary small">قراءة الكل</a>
                    <?php endif; ?>
                </div>
                <?php if (empty($notifications)): ?>
                <div class="p-3 text-center text-muted small">لا توجد إشعارات</div>
                <?php else: ?>
                <?php foreach ($notifications as $notif): ?>
                <div class="n-item <?= !$notif['is_read'] ? 'unread' : '' ?>">
                    <div class="fw-bold small"><?= clean($notif['title']) ?></div>
                    <div class="text-muted" style="font-size:0.78rem"><?= clean($notif['message']) ?></div>
                    <div class="text-muted" style="font-size:0.7rem;margin-top:3px"><?= date('Y/m/d H:i', strtotime($notif['created_at'])) ?></div>
                </div>
                <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <div class="dropdown">
            <div class="user-avatar dropdown-toggle" data-bs-toggle="dropdown" style="cursor:pointer;">
                <?= $userInitial ?>
            </div>
            <ul class="dropdown-menu dropdown-menu-start">
                <li><span class="dropdown-item-text fw-bold"><?= clean($_SESSION['full_name']) ?></span></li>
                <li><span class="dropdown-item-text text-muted small"><?= $_SESSION['role'] == 'admin' ? 'مدير النظام' : 'وكيل' ?></span></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user-circle me-2"></i>الملف الشخصي</a></li>
                <li><a class="dropdown-item text-danger" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>تسجيل الخروج</a></li>
            </ul>
        </div>
    </div>
</nav>

<!-- Main Content -->
<main class="main-content fade-in">
