<?php
/**
 * Prince VIP System - Login Page
 * صفحة تسجيل الدخول
 */
require_once 'config/database.php';

// إذا كان المستخدم مسجل دخوله، يتم توجيهه للوحة التحكم
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = clean($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'يرجى إدخال اسم المستخدم وكلمة المرور';
    } else {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE username = ? AND is_active = 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            // تسجيل الجلسة
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['role'] = $user['role'];
            
            // تحديث آخر تسجيل دخول
            $db->prepare("UPDATE users SET last_login = NOW() WHERE id = ?")->execute([$user['id']]);
            
            // تسجيل النشاط
            $db->prepare("INSERT INTO activity_log (user_id, action, description, ip_address) VALUES (?, 'login', 'تسجيل دخول', ?)")
               ->execute([$user['id'], $_SERVER['REMOTE_ADDR']]);
            
            redirect('dashboard.php');
        } else {
            $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - Prince VIP System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800;900&display=swap" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>

<div class="login-page">
    <div class="login-card text-center">
        <!-- Logo -->
        <img src="images/logo.png" alt="Prince VIP" class="login-logo">
        
        <h3 class="login-title">Prince VIP</h3>
        <p class="login-subtitle">نظام إدارة وتصدير بوالص VIP</p>
        
        <?php if ($error): ?>
        <div class="alert alert-danger alert-custom py-2 mb-3" style="font-size:0.9rem;">
            <i class="fas fa-exclamation-circle me-1"></i>
            <?= $error ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="" autocomplete="off">
            <div class="text-start mb-3">
                <label class="form-label">اسم المستخدم</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                    <input type="text" name="username" class="form-control" placeholder="أدخل اسم المستخدم" 
                           value="<?= clean($_POST['username'] ?? '') ?>" required autofocus>
                </div>
            </div>
            
            <div class="text-start mb-4">
                <label class="form-label">كلمة المرور</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" name="password" class="form-control" placeholder="أدخل كلمة المرور" required>
                </div>
            </div>
            
            <button type="submit" class="btn btn-login">
                تسجيل الدخول <i class="fas fa-arrow-left me-1"></i>
            </button>
        </form>
    </div>
    
    <div class="login-footer">
        Powered by <a href="#">Mtech Pro</a> &copy; <?= date('Y') ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
