<?php
/**
 * Prince VIP System - Auto Installer
 * ملف التثبيت التلقائي لقاعدة البيانات
 */

$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'prince_vip';

try {
    // الاتصال بدون قاعدة بيانات محددة
    $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    // إنشاء قاعدة البيانات
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    $pdo->exec("USE `$dbname`");
    
    // ======= جدول المستخدمين =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `users` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `username` VARCHAR(100) NOT NULL UNIQUE,
        `password` VARCHAR(255) NOT NULL,
        `full_name` VARCHAR(255) NOT NULL,
        `email` VARCHAR(255) DEFAULT NULL,
        `phone` VARCHAR(20) DEFAULT NULL,
        `role` ENUM('admin','agent') NOT NULL DEFAULT 'agent',
        `is_active` TINYINT(1) NOT NULL DEFAULT 1,
        `last_login` DATETIME DEFAULT NULL,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= جدول العملاء =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `clients` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `full_name` VARCHAR(255) NOT NULL,
        `id_number` VARCHAR(20) NOT NULL,
        `phone` VARCHAR(20) NOT NULL,
        `email` VARCHAR(255) DEFAULT NULL,
        `address` TEXT DEFAULT NULL,
        `created_by` INT DEFAULT NULL,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= جدول العقود =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `contracts` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `contract_number` VARCHAR(20) NOT NULL UNIQUE,
        `card_number` VARCHAR(50) DEFAULT NULL,
        `client_id` INT NOT NULL,
        `agent_id` INT NOT NULL,
        `plate_type` VARCHAR(100) DEFAULT NULL,
        `classification` VARCHAR(100) DEFAULT NULL,
        `car_number` VARCHAR(50) DEFAULT NULL,
        `license_type` VARCHAR(50) DEFAULT NULL,
        `car_type` VARCHAR(100) DEFAULT NULL,
        `car_color` VARCHAR(50) DEFAULT NULL,
        `production_year` INT DEFAULT NULL,
        `usage_type` VARCHAR(50) DEFAULT NULL,
        `insurance_type` VARCHAR(100) DEFAULT NULL,
        `chassis_number` VARCHAR(17) DEFAULT NULL,
        `start_date` DATE NOT NULL,
        `end_date` DATE NOT NULL,
        `notes` TEXT DEFAULT NULL,
        `status` ENUM('draft','pending','active','rejected','expired') NOT NULL DEFAULT 'draft',
        `admin_notes` TEXT DEFAULT NULL,
        `attachment1` VARCHAR(255) DEFAULT NULL,
        `attachment2` VARCHAR(255) DEFAULT NULL,
        `attachment3` VARCHAR(255) DEFAULT NULL,
        `policy_number` VARCHAR(20) DEFAULT NULL,
        `policy_issued_at` DATETIME DEFAULT NULL,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (`client_id`) REFERENCES `clients`(`id`) ON DELETE CASCADE,
        FOREIGN KEY (`agent_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= جدول الإعدادات (القوائم المنسدلة) =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `settings_options` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `category` VARCHAR(50) NOT NULL,
        `option_value` VARCHAR(255) NOT NULL,
        `sort_order` INT DEFAULT 0,
        `is_active` TINYINT(1) DEFAULT 1,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= جدول سجل النشاطات =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `activity_log` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `user_id` INT DEFAULT NULL,
        `action` VARCHAR(100) NOT NULL,
        `description` TEXT DEFAULT NULL,
        `target_type` VARCHAR(50) DEFAULT NULL,
        `target_id` INT DEFAULT NULL,
        `ip_address` VARCHAR(45) DEFAULT NULL,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= جدول الإشعارات =======
    $pdo->exec("CREATE TABLE IF NOT EXISTS `notifications` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `user_id` INT NOT NULL,
        `title` VARCHAR(255) NOT NULL,
        `message` TEXT NOT NULL,
        `is_read` TINYINT(1) DEFAULT 0,
        `link` VARCHAR(255) DEFAULT NULL,
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    
    // ======= إدخال البيانات الافتراضية =======
    
    // التحقق من وجود مستخدم admin
    $stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE username = 'admin'");
    if ($stmt->fetchColumn() == 0) {
        $adminPass = password_hash('admin123', PASSWORD_DEFAULT);
        $pdo->exec("INSERT INTO `users` (`username`, `password`, `full_name`, `email`, `phone`, `role`, `is_active`) 
                     VALUES ('admin', '$adminPass', 'مدير النظام', 'admin@princevip.ps', '0599000000', 'admin', 1)");
        
        // إضافة وكيل تجريبي
        $agentPass = password_hash('agent123', PASSWORD_DEFAULT);
        $pdo->exec("INSERT INTO `users` (`username`, `password`, `full_name`, `email`, `phone`, `role`, `is_active`) 
                     VALUES ('agent1', '$agentPass', 'أحمد الوكيل', 'agent@princevip.ps', '0598000000', 'agent', 1)");
    }
    
    // إدخال خيارات القوائم المنسدلة الافتراضية
    $stmt = $pdo->query("SELECT COUNT(*) FROM settings_options");
    if ($stmt->fetchColumn() == 0) {
        $options = [
            // أنواع نمر السيارات
            ['plate_type', 'نمرة ضفة فلسطين', 1],
            ['plate_type', 'نمرة القدس', 2],
            ['plate_type', 'نمرة 48', 3],
            ['plate_type', 'أخرى', 4],
            
            // التصنيفات
            ['classification', 'صالون', 1],
            ['classification', 'جيب', 2],
            ['classification', 'فان', 3],
            ['classification', 'شاحنة', 4],
            ['classification', 'دراجة نارية', 5],
            ['classification', 'باص', 6],
            ['classification', 'أخرى', 7],
            
            // صفة الاستخدام
            ['usage_type', 'شخصي', 1],
            ['usage_type', 'تجاري', 2],
            ['usage_type', 'حكومي', 3],
            ['usage_type', 'سياحي', 4],
            ['usage_type', 'آخر', 5],
            
            // نوع التأمين
            ['insurance_type', 'شامل', 1],
            ['insurance_type', 'ضد الغير', 2],
            ['insurance_type', 'تأمين شخصي', 3],
            ['insurance_type', 'بدون تأمين', 4],
            
            // نوع الترخيص
            ['license_type', 'ترخيص جديد', 1],
            ['license_type', 'تجديد', 2],
            
            // أنواع المركبات
            ['car_type', 'تويوتا', 1],
            ['car_type', 'هيونداي', 2],
            ['car_type', 'كيا', 3],
            ['car_type', 'نيسان', 4],
            ['car_type', 'مرسيدس', 5],
            ['car_type', 'بي ام دبليو', 6],
            ['car_type', 'فولكسفاجن', 7],
            ['car_type', 'هوندا', 8],
            ['car_type', 'فورد', 9],
            ['car_type', 'شيفروليه', 10],
            ['car_type', 'سكودا', 11],
            ['car_type', 'أخرى', 12],
        ];
        
        $insertStmt = $pdo->prepare("INSERT INTO settings_options (category, option_value, sort_order) VALUES (?, ?, ?)");
        foreach ($options as $opt) {
            $insertStmt->execute($opt);
        }
    }
    
    echo '<!DOCTYPE html><html lang="ar" dir="rtl"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تثبيت النظام</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>body{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;display:flex;align-items:center;justify-content:center;font-family:Tajawal,sans-serif;}
    .card{border-radius:20px;box-shadow:0 20px 60px rgba(0,0,0,0.3);}</style>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    </head><body><div class="card p-5 text-center" style="max-width:500px;">
    <div class="mb-4"><svg width="80" height="80" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="12" r="12" fill="#28a745"/><path d="M9 12l2 2 4-4" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg></div>
    <h2 class="text-success mb-3">✅ تم التثبيت بنجاح!</h2>
    <p class="text-muted mb-4">تم إنشاء قاعدة البيانات وجميع الجداول بنجاح</p>
    <div class="alert alert-info text-start">
    <strong>بيانات المدير:</strong><br>اسم المستخدم: <code>admin</code><br>كلمة المرور: <code>admin123</code>
    <hr>
    <strong>بيانات الوكيل التجريبي:</strong><br>اسم المستخدم: <code>agent1</code><br>كلمة المرور: <code>agent123</code>
    </div>
    <a href="index.php" class="btn btn-primary btn-lg mt-3">الذهاب لتسجيل الدخول</a>
    </div></body></html>';
    
} catch (PDOException $e) {
    echo '<!DOCTYPE html><html lang="ar" dir="rtl"><head><meta charset="UTF-8">
    <title>خطأ في التثبيت</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    </head><body class="p-5"><div class="alert alert-danger"><h4>❌ خطأ في التثبيت</h4><p>' . $e->getMessage() . '</p></div></body></html>';
}
