<?php
/**
 * Prince VIP System - Notifications
 */
$pageTitle = 'الإشعارات';
require_once 'includes/header.php';
$db = getDB();

// تحديث كل الإشعارات كمقروءة
$db->prepare("UPDATE notifications SET is_read = 1 WHERE user_id = ?")->execute([$_SESSION['user_id']]);

$stmt = $db->prepare("SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC LIMIT 50");
$stmt->execute([$_SESSION['user_id']]);
$allNotifs = $stmt->fetchAll();
?>

<h4 class="fw-bold mb-4"><i class="fas fa-bell text-primary me-2"></i>الإشعارات</h4>

<div class="content-card">
    <div class="card-body">
        <?php if (empty($allNotifs)): ?>
        <div class="empty-state">
            <i class="fas fa-bell-slash"></i>
            <h5>لا توجد إشعارات</h5>
        </div>
        <?php else: ?>
        <?php foreach ($allNotifs as $notif): ?>
        <div class="d-flex align-items-start gap-3 p-3 border-bottom">
            <div class="nav-icon bg-light" style="min-width:40px;height:40px;border-radius:50%;display:flex;align-items:center;justify-content:center;">
                <i class="fas fa-bell text-primary"></i>
            </div>
            <div class="flex-grow-1">
                <div class="fw-bold"><?= clean($notif['title']) ?></div>
                <div class="text-muted small"><?= clean($notif['message']) ?></div>
                <div class="text-muted" style="font-size:0.75rem;margin-top:4px;">
                    <i class="fas fa-clock me-1"></i><?= date('Y/m/d H:i', strtotime($notif['created_at'])) ?>
                </div>
            </div>
            <?php if ($notif['link']): ?>
            <a href="<?= $notif['link'] ?>" class="btn btn-sm btn-outline-gold">عرض</a>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
