<?php
/**
 * Prince VIP System - Policy PDF Export
 * تصدير البوليصة كملف PDF
 * يستخدم HTML مع CSS للطباعة
 */
require_once 'config/database.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$db = getDB();
$contractId = (int)($_GET['id'] ?? 0);

if (!$contractId) {
    die('عقد غير موجود');
}

$stmt = $db->prepare("SELECT c.*, cl.full_name as client_name, cl.id_number as client_id_number, 
                       cl.phone as client_phone, cl.address as client_address,
                       u.full_name as agent_name 
                       FROM contracts c 
                       JOIN clients cl ON c.client_id = cl.id 
                       JOIN users u ON c.agent_id = u.id 
                       WHERE c.id = ?");
$stmt->execute([$contractId]);
$contract = $stmt->fetch();

if (!$contract) {
    die('العقد غير موجود');
}

// التحقق من الصلاحية
if (!isAdmin() && $contract['agent_id'] != $_SESSION['user_id']) {
    die('غير مصرح');
}

// توليد رمز التحقق
$verificationCode = strtoupper(substr(md5($contract['contract_number'] . $contract['created_at']), 0, 12));
$verificationFormatted = implode('-', str_split($verificationCode, 4));

// مسار الشعار
$logoPath = 'images/logo.png';
$logoData = '';
if (file_exists($logoPath)) {
    $logoData = 'data:image/png;base64,' . base64_encode(file_get_contents($logoPath));
}

// تسجيل النشاط
$db->prepare("INSERT INTO activity_log (user_id, action, description, target_type, target_id, ip_address) VALUES (?, 'export_policy', ?, 'contract', ?, ?)")
   ->execute([$_SESSION['user_id'], "تصدير بوليصة العقد رقم " . $contract['contract_number'], $contractId, $_SERVER['REMOTE_ADDR']]);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بوليصة رقم <?= $contract['contract_number'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800;900&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            direction: rtl;
            background: #f5f5f5;
            color: #333;
        }
        
        .policy-container {
            max-width: 800px;
            margin: 20px auto;
            background: #fff;
            box-shadow: 0 5px 30px rgba(0,0,0,0.1);
            position: relative;
        }
        
        /* Header */
        .policy-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: #fff;
            padding: 30px 40px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .policy-logo img {
            width: 90px;
            height: auto;
        }
        
        .policy-company {
            text-align: center;
            flex: 1;
        }
        
        .policy-company h1 {
            font-size: 1.8rem;
            font-weight: 800;
            color: #DAA520;
            margin-bottom: 5px;
        }
        
        .policy-company h2 {
            font-size: 1rem;
            font-weight: 500;
            color: rgba(255,255,255,0.7);
        }
        
        .policy-number-box {
            text-align: center;
            background: rgba(218,165,32,0.15);
            border: 2px solid #DAA520;
            border-radius: 10px;
            padding: 10px 20px;
        }
        
        .policy-number-box small {
            display: block;
            color: #DAA520;
            font-size: 0.75rem;
            font-weight: 700;
        }
        
        .policy-number-box strong {
            font-size: 1.2rem;
            color: #fff;
        }
        
        /* Gold Bar */
        .gold-bar {
            background: linear-gradient(90deg, #DAA520, #FFD700, #DAA520);
            height: 4px;
        }
        
        /* Title */
        .policy-title {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
        }
        
        .policy-title h3 {
            font-size: 1.4rem;
            font-weight: 800;
            color: #1a1a2e;
        }
        
        .policy-title p {
            color: #666;
            font-size: 0.9rem;
        }
        
        /* Body */
        .policy-body {
            padding: 30px 40px;
        }
        
        .section-title {
            font-size: 1rem;
            font-weight: 700;
            color: #DAA520;
            border-bottom: 2px solid #DAA520;
            padding-bottom: 8px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-bottom: 25px;
        }
        
        .info-item {
            display: flex;
            border: 1px solid #e9ecef;
            border-radius: 6px;
            overflow: hidden;
        }
        
        .info-item .label {
            background: #f8f9fa;
            padding: 8px 12px;
            font-weight: 700;
            font-size: 0.82rem;
            color: #555;
            min-width: 120px;
            border-left: 1px solid #e9ecef;
        }
        
        .info-item .value {
            padding: 8px 12px;
            font-size: 0.9rem;
            font-weight: 500;
            flex: 1;
        }
        
        .info-full {
            grid-column: 1 / -1;
        }
        
        /* Dates */
        .dates-section {
            display: flex;
            gap: 20px;
            margin-bottom: 25px;
        }
        
        .date-box {
            flex: 1;
            background: linear-gradient(135deg, #f8f9fa, #fff);
            border: 2px solid #DAA520;
            border-radius: 10px;
            padding: 15px;
            text-align: center;
        }
        
        .date-box .date-label {
            font-size: 0.8rem;
            color: #666;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .date-box .date-value {
            font-size: 1.3rem;
            font-weight: 800;
            color: #1a1a2e;
        }
        
        /* Verification */
        .verification {
            background: #f8f9fa;
            border: 2px dashed #DAA520;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            margin-top: 25px;
        }
        
        .verification .code {
            font-size: 1.5rem;
            font-weight: 900;
            color: #1a1a2e;
            letter-spacing: 3px;
            font-family: monospace;
        }
        
        .verification small {
            display: block;
            color: #666;
            font-size: 0.8rem;
            margin-top: 5px;
        }
        
        /* Footer */
        .policy-footer {
            background: #1a1a2e;
            color: rgba(255,255,255,0.6);
            text-align: center;
            padding: 15px;
            font-size: 0.8rem;
        }
        
        .policy-footer strong {
            color: #DAA520;
        }
        
        /* Issue info */
        .issue-info {
            display: flex;
            justify-content: space-between;
            padding: 15px 40px;
            background: #fff;
            border-top: 1px solid #e9ecef;
            font-size: 0.8rem;
            color: #999;
        }
        
        /* Print controls */
        .print-controls {
            text-align: center;
            padding: 20px;
            background: #fff;
            max-width: 800px;
            margin: 0 auto 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .print-controls button, .print-controls a {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 25px;
            border: none;
            border-radius: 8px;
            font-family: 'Tajawal';
            font-weight: 600;
            font-size: 0.95rem;
            cursor: pointer;
            text-decoration: none;
            margin: 0 5px;
            transition: all 0.3s ease;
        }
        
        .btn-print {
            background: linear-gradient(135deg, #DAA520, #FFD700);
            color: #fff;
        }
        
        .btn-print:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(218,165,32,0.4);
        }
        
        .btn-back {
            background: #6c757d;
            color: #fff;
        }
        
        .btn-back:hover {
            background: #5a6268;
            color: #fff;
        }
        
        @media print {
            body { background: #fff; }
            .print-controls { display: none !important; }
            .policy-container { box-shadow: none; margin: 0; max-width: 100%; }
        }
        
        @media (max-width: 600px) {
            .policy-header { flex-direction: column; gap: 15px; padding: 20px; }
            .policy-body { padding: 20px; }
            .info-grid { grid-template-columns: 1fr; }
            .dates-section { flex-direction: column; }
            .info-item .label { min-width: 100px; font-size: 0.75rem; }
        }
    </style>
</head>
<body>

<!-- أزرار التحكم -->
<div class="print-controls no-print">
    <button class="btn-print" onclick="window.print()">
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M6 9V2h12v7"/><path d="M6 18H4a2 2 0 01-2-2v-5a2 2 0 012-2h16a2 2 0 012 2v5a2 2 0 01-2 2h-2"/><rect x="6" y="14" width="12" height="8"/></svg>
        طباعة البوليصة
    </button>
    <a href="contract_view.php?id=<?= $contract['id'] ?>" class="btn-back">
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 12H5M12 19l-7-7 7-7"/></svg>
        العودة للعقد
    </a>
</div>

<!-- البوليصة -->
<div class="policy-container" id="policyContent">
    <!-- Header -->
    <div class="policy-header">
        <div class="policy-logo">
            <?php if ($logoData): ?>
            <img src="<?= $logoData ?>" alt="Logo">
            <?php endif; ?>
        </div>
        <div class="policy-company">
            <h1>Prince VIP</h1>
            <h2>نظام إدارة وتصدير بوالص VIP</h2>
        </div>
        <div class="policy-number-box">
            <small>رقم البوليصة</small>
            <strong>POL-<?= $contract['contract_number'] ?></strong>
        </div>
    </div>
    
    <div class="gold-bar"></div>
    
    <!-- Title -->
    <div class="policy-title">
        <h3>بوليصة تأمين المركبات VIP</h3>
        <p>هذه الوثيقة تثبت تفاصيل عقد التأمين والاشتراك</p>
    </div>
    
    <div class="policy-body">
        <!-- بيانات العميل -->
        <div class="section-title">📋 بيانات العميل</div>
        <div class="info-grid">
            <div class="info-item info-full">
                <div class="label">الاسم الكامل</div>
                <div class="value" style="font-weight:700;"><?= clean($contract['client_name']) ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الهوية</div>
                <div class="value"><?= clean($contract['client_id_number']) ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الجوال</div>
                <div class="value"><?= clean($contract['client_phone']) ?></div>
            </div>
        </div>
        
        <!-- بيانات المركبة -->
        <div class="section-title">🚗 بيانات المركبة</div>
        <div class="info-grid">
            <div class="info-item">
                <div class="label">نوع النمرة</div>
                <div class="value"><?= clean($contract['plate_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم السيارة</div>
                <div class="value" style="font-weight:700;font-size:1rem;"><?= clean($contract['car_number'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">التصنيف</div>
                <div class="value"><?= clean($contract['classification'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع السيارة</div>
                <div class="value"><?= clean($contract['car_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">لون السيارة</div>
                <div class="value"><?= clean($contract['car_color'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">سنة الإنتاج</div>
                <div class="value"><?= $contract['production_year'] ?? '-' ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع الترخيص</div>
                <div class="value"><?= clean($contract['license_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">صفة الاستخدام</div>
                <div class="value"><?= clean($contract['usage_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع التأمين</div>
                <div class="value" style="font-weight:700;color:#DAA520;"><?= clean($contract['insurance_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الشاصي</div>
                <div class="value" style="font-family:monospace;letter-spacing:1px;"><?= clean($contract['chassis_number'] ?? '-') ?></div>
            </div>
        </div>
        
        <!-- التواريخ -->
        <div class="section-title">📅 فترة الاشتراك</div>
        <div class="dates-section">
            <div class="date-box">
                <div class="date-label">تاريخ بداية الاشتراك</div>
                <div class="date-value"><?= $contract['start_date'] ?></div>
            </div>
            <div class="date-box">
                <div class="date-label">تاريخ انتهاء الاشتراك</div>
                <div class="date-value"><?= $contract['end_date'] ?></div>
            </div>
        </div>
        
        <?php if ($contract['notes']): ?>
        <div class="section-title" style="margin-top:20px;">📝 ملاحظات</div>
        <p style="color:#666;font-size:0.9rem;padding:10px;background:#f8f9fa;border-radius:8px;"><?= nl2br(clean($contract['notes'])) ?></p>
        <?php endif; ?>
        
        <!-- رمز التحقق -->
        <div class="verification">
            <div>🔒 رمز التحقق الإلكتروني</div>
            <div class="code"><?= $verificationFormatted ?></div>
            <small>هذه البوليصة صادرة إلكترونياً ولا تحتاج إلى توقيع</small>
        </div>
    </div>
    
    <!-- معلومات الإصدار -->
    <div class="issue-info">
        <span>تاريخ الإصدار: <?= date('Y/m/d H:i') ?></span>
        <span>الوكيل: <?= clean($contract['agent_name']) ?></span>
        <span>رقم العقد: <?= clean($contract['contract_number']) ?></span>
    </div>
    
    <!-- Footer -->
    <div class="policy-footer">
        <strong>Prince VIP System</strong> - نظام إدارة وتصدير بوالص VIP | 
        Powered by <strong>Mtech Pro</strong> &copy; <?= date('Y') ?>
    </div>
</div>

</body>
</html>
