<?php
/**
 * Prince VIP System - Profile
 */
$pageTitle = 'الملف الشخصي';
require_once 'includes/header.php';
$db = getDB();

$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();
?>

<h4 class="fw-bold mb-4"><i class="fas fa-user-circle text-primary me-2"></i>الملف الشخصي</h4>

<div class="row">
    <div class="col-lg-6">
        <div class="content-card">
            <div class="card-header">
                <h5><i class="fas fa-id-badge text-primary"></i> المعلومات الشخصية</h5>
            </div>
            <div class="card-body">
                <form id="profileForm">
                    <div class="form-group">
                        <label>الاسم الكامل</label>
                        <input type="text" name="full_name" class="form-control" value="<?= clean($user['full_name']) ?>">
                    </div>
                    <div class="form-group">
                        <label>البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control" value="<?= clean($user['email'] ?? '') ?>">
                    </div>
                    <div class="form-group">
                        <label>رقم الجوال</label>
                        <input type="text" name="phone" class="form-control" value="<?= clean($user['phone'] ?? '') ?>">
                    </div>
                    <button type="button" id="updateProfile" class="btn btn-gold">
                        <i class="fas fa-save me-1"></i> حفظ التعديلات
                    </button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="content-card">
            <div class="card-header">
                <h5><i class="fas fa-lock text-warning"></i> تغيير كلمة المرور</h5>
            </div>
            <div class="card-body">
                <form id="passwordForm">
                    <div class="form-group">
                        <label>كلمة المرور الحالية</label>
                        <input type="password" name="current_password" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>كلمة المرور الجديدة</label>
                        <input type="password" name="new_password" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>تأكيد كلمة المرور</label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                    <button type="button" id="changePassword" class="btn btn-gold">
                        <i class="fas fa-key me-1"></i> تغيير كلمة المرور
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
$extraJS = <<<'JS'
<script>
$('#updateProfile').on('click', function() {
    ajaxRequest('ajax/profile.php', $('#profileForm').serialize() + '&action=update', function(r) {
        if (r.success) showAlert(r.message, 'success');
        else showAlert(r.message, 'danger');
    });
});

$('#changePassword').on('click', function() {
    ajaxRequest('ajax/profile.php', $('#passwordForm').serialize() + '&action=password', function(r) {
        if (r.success) { showAlert(r.message, 'success'); $('#passwordForm')[0].reset(); }
        else showAlert(r.message, 'danger');
    });
});
</script>
JS;

require_once 'includes/footer.php';
?>
