<?php
/**
 * Prince VIP System - Packages Management
 * إدارة الحزم والأسعار
 */
$pageTitle = 'إدارة الحزم';
require_once 'includes/header.php';

if (!isAdmin()) {
    redirect('dashboard.php');
}

$db = getDB();
$packages = $db->query("SELECT * FROM packages ORDER BY package_type, sort_order, name")->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1"><i class="fas fa-box-open text-primary me-2"></i>إدارة الحزم والأسعار</h4>
        <p class="text-muted small mb-0">إدارة حزم التأمين وتحديد الأسعار</p>
    </div>
    <button class="btn btn-gold" onclick="showAddPackageModal()">
        <i class="fas fa-plus me-1"></i> إضافة حزمة جديدة
    </button>
</div>

<div class="row">
    <!-- الحزم الخصوصية -->
    <div class="col-lg-6">
        <div class="content-card">
            <div class="card-header">
                <h5><i class="fas fa-car text-info"></i> الحزم الخصوصية</h5>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>اسم الحزمة</th>
                            <th>السعر (₪)</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($packages as $pkg): ?>
                        <?php if ($pkg['package_type'] === 'private'): ?>
                        <tr>
                            <td class="fw-bold"><?= clean($pkg['name']) ?></td>
                            <td><span class="text-success fw-bold"><?= number_format($pkg['price'], 2) ?></span></td>
                            <td>
                                <span class="badge <?= $pkg['is_active'] ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= $pkg['is_active'] ? 'مفعّل' : 'معطّل' ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="editPackage(<?= $pkg['id'] ?>, '<?= clean($pkg['name']) ?>', '<?= $pkg['package_type'] ?>', <?= $pkg['price'] ?>, '<?= clean($pkg['description'] ?? '') ?>')">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-outline-<?= $pkg['is_active'] ? 'warning' : 'success' ?>" onclick="togglePackage(<?= $pkg['id'] ?>, <?= $pkg['is_active'] ? 0 : 1 ?>)">
                                    <i class="fas fa-<?= $pkg['is_active'] ? 'ban' : 'check' ?>"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- الحزم التجارية -->
    <div class="col-lg-6">
        <div class="content-card">
            <div class="card-header">
                <h5><i class="fas fa-truck text-warning"></i> الحزم التجارية</h5>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>اسم الحزمة</th>
                            <th>السعر (₪)</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($packages as $pkg): ?>
                        <?php if ($pkg['package_type'] === 'commercial'): ?>
                        <tr>
                            <td class="fw-bold"><?= clean($pkg['name']) ?></td>
                            <td><span class="text-success fw-bold"><?= number_format($pkg['price'], 2) ?></span></td>
                            <td>
                                <span class="badge <?= $pkg['is_active'] ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= $pkg['is_active'] ? 'مفعّل' : 'معطّل' ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="editPackage(<?= $pkg['id'] ?>, '<?= clean($pkg['name']) ?>', '<?= $pkg['package_type'] ?>', <?= $pkg['price'] ?>, '<?= clean($pkg['description'] ?? '') ?>')">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-outline-<?= $pkg['is_active'] ? 'warning' : 'success' ?>" onclick="togglePackage(<?= $pkg['id'] ?>, <?= $pkg['is_active'] ? 0 : 1 ?>)">
                                    <i class="fas fa-<?= $pkg['is_active'] ? 'ban' : 'check' ?>"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal إضافة/تعديل حزمة -->
<div class="modal fade" id="packageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="packageModalTitle">إضافة حزمة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="packageForm">
                    <input type="hidden" name="id" id="pkgId">
                    <div class="form-group">
                        <label>اسم الحزمة <span class="required">*</span></label>
                        <input type="text" name="name" id="pkgName" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>نوع الحزمة <span class="required">*</span></label>
                        <select name="package_type" id="pkgType" class="form-select" required>
                            <option value="private">خصوصي</option>
                            <option value="commercial">تجاري</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>السعر (₪) <span class="required">*</span></label>
                        <input type="number" name="price" id="pkgPrice" class="form-control" step="0.01" min="0" required>
                    </div>
                    <div class="form-group mb-0">
                        <label>وصف الحزمة</label>
                        <textarea name="description" id="pkgDesc" class="form-control" rows="2"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-gold" onclick="savePackage()">حفظ</button>
            </div>
        </div>
    </div>
</div>

<?php
$extraJS = <<<'JS'
<script>
function showAddPackageModal() {
    $('#packageModalTitle').text('إضافة حزمة جديدة');
    $('#pkgId').val('');
    $('#pkgName').val('');
    $('#pkgType').val('private');
    $('#pkgPrice').val('');
    $('#pkgDesc').val('');
    new bootstrap.Modal('#packageModal').show();
}

function editPackage(id, name, type, price, desc) {
    $('#packageModalTitle').text('تعديل الحزمة');
    $('#pkgId').val(id);
    $('#pkgName').val(name);
    $('#pkgType').val(type);
    $('#pkgPrice').val(price);
    $('#pkgDesc').val(desc);
    new bootstrap.Modal('#packageModal').show();
}

function savePackage() {
    const data = {
        action: $('#pkgId').val() ? 'update' : 'create',
        id: $('#pkgId').val(),
        name: $('#pkgName').val(),
        package_type: $('#pkgType').val(),
        price: $('#pkgPrice').val(),
        description: $('#pkgDesc').val()
    };
    
    if (!data.name || !data.price) {
        showAlert('يرجى إكمال البيانات المطلوبة', 'warning');
        return;
    }
    
    ajaxRequest('ajax/packages.php', data, function(response) {
        if (response.success) {
            showAlert(response.message, 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert(response.message, 'danger');
        }
    });
}

function togglePackage(id, active) {
    ajaxRequest('ajax/packages.php', { action: 'toggle', id: id, is_active: active }, function(response) {
        if (response.success) {
            showAlert(response.message, 'success');
            setTimeout(() => location.reload(), 800);
        }
    });
}
</script>
JS;

require_once 'includes/footer.php';
?>
