<?php
/**
 * Prince VIP System - Policy PDF Export
 * تصدير البوليصة كملف PDF
 * يستخدم HTML مع CSS للطباعة
 */
require_once 'config/database.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$db = getDB();
$contractId = (int)($_GET['id'] ?? 0);

if (!$contractId) {
    die('عقد غير موجود');
}

$stmt = $db->prepare("SELECT c.*, cl.full_name as client_name, cl.id_number as client_id_number, 
                       cl.phone as client_phone, cl.address as client_address,
                       u.full_name as agent_name,
                       p.name as package_name, p.package_type as package_type
                       FROM contracts c 
                       JOIN clients cl ON c.client_id = cl.id 
                       JOIN users u ON c.agent_id = u.id 
                       LEFT JOIN packages p ON c.package_id = p.id 
                       WHERE c.id = ?");
$stmt->execute([$contractId]);
$contract = $stmt->fetch();

if (!$contract) {
    die('العقد غير موجود');
}

// التحقق من الصلاحية
if (!isAdmin() && $contract['agent_id'] != $_SESSION['user_id']) {
    die('غير مصرح');
}

// توليد رمز التحقق
$verificationCode = strtoupper(substr(md5($contract['contract_number'] . $contract['created_at']), 0, 12));
$verificationFormatted = implode('-', str_split($verificationCode, 4));

// مسار الشعار
$logoPath = 'images/logo.png';
$logoData = '';
if (file_exists($logoPath)) {
    $logoData = 'data:image/png;base64,' . base64_encode(file_get_contents($logoPath));
}

// تسجيل النشاط
$db->prepare("INSERT INTO activity_log (user_id, action, description, target_type, target_id, ip_address) VALUES (?, 'export_policy', ?, 'contract', ?, ?)")
   ->execute([$_SESSION['user_id'], "تصدير بوليصة العقد رقم " . $contract['contract_number'], $contractId, $_SERVER['REMOTE_ADDR']]);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بوليصة رقم <?= $contract['contract_number'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800;900&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            direction: rtl;
            background: #f5f5f5;
            color: #333;
        }
        
        .policy-container {
            max-width: 800px;
            margin: 20px auto;
            background: #fff;
            box-shadow: 0 5px 30px rgba(0,0,0,0.1);
            position: relative;
            min-height: 297mm;
            display: flex;
            flex-direction: column;
        }
        
        /* Header */
        .policy-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: #fff;
            padding: 18px 35px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .policy-logo img {
            width: 70px;
            height: auto;
        }
        
        .policy-company {
            text-align: center;
            flex: 1;
        }
        
        .policy-company h1 {
            font-size: 1.5rem;
            font-weight: 800;
            color: #DAA520;
            margin-bottom: 2px;
        }
        
        .policy-company h2 {
            font-size: 0.9rem;
            font-weight: 500;
            color: rgba(255,255,255,0.7);
        }
        
        .policy-number-box {
            text-align: center;
            background: rgba(218,165,32,0.15);
            border: 2px solid #DAA520;
            border-radius: 8px;
            padding: 10px 18px;
        }
        
        .policy-number-box small {
            display: block;
            color: #DAA520;
            font-size: 0.8rem;
            font-weight: 700;
        }
        
        .policy-number-box strong {
            font-size: 1.3rem;
            color: #fff;
        }
        
        /* Gold Bar */
        .gold-bar {
            background: linear-gradient(90deg, #DAA520, #FFD700, #DAA520);
            height: 4px;
        }
        
        /* Title */
        .policy-title {
            text-align: center;
            padding: 14px;
            background: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
        }
        
        .policy-title h3 {
            font-size: 1.3rem;
            font-weight: 800;
            color: #1a1a2e;
        }
        
        .policy-title p {
            color: #666;
            font-size: 0.8rem;
        }
        
        /* Body */
        .policy-body {
            padding: 18px 35px;
            flex: 1;
        }
        
        .section-title {
            font-size: 1rem;
            font-weight: 700;
            color: #DAA520;
            border-bottom: 2px solid #DAA520;
            padding-bottom: 5px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .info-item {
            display: flex;
            border: 1px solid #e9ecef;
            border-radius: 6px;
            overflow: hidden;
        }
        
        .info-item .label {
            background: #f8f9fa;
            padding: 6px 12px;
            font-weight: 700;
            font-size: 0.8rem;
            color: #555;
            min-width: 105px;
            border-left: 1px solid #e9ecef;
        }
        
        .info-item .value {
            padding: 6px 12px;
            font-size: 0.85rem;
            font-weight: 500;
            flex: 1;
        }
        
        .info-full {
            grid-column: 1 / -1;
        }
        
        /* Dates */
        .dates-section {
            display: flex;
            gap: 15px;
            margin-bottom: 10px;
        }
        
        .date-box {
            flex: 1;
            background: linear-gradient(135deg, #f8f9fa, #fff);
            border: 2px solid #DAA520;
            border-radius: 8px;
            padding: 10px;
            text-align: center;
        }
        
        .date-box .date-label {
            font-size: 0.75rem;
            color: #666;
            font-weight: 600;
            margin-bottom: 4px;
        }
        
        .date-box .date-value {
            font-size: 1.05rem;
            font-weight: 800;
            color: #1a1a2e;
        }
        
        /* Stamp */
        .stamp-section {
            text-align: center;
            margin-top: 10px;
            padding: 8px 0;
        }
        
        .stamp-circle {
            display: inline-block;
            width: 110px;
            height: 110px;
            border: 3px solid #DAA520;
            border-radius: 50%;
            padding: 10px;
            opacity: 0.85;
            position: relative;
            background: #fff;
        }
        
        .stamp-circle img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        
        .stamp-circle::after {
            content: '✓ معتمد';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            background: #DAA520;
            color: #fff;
            font-size: 0.65rem;
            font-weight: 800;
            padding: 2px 12px;
            border-radius: 8px;
            white-space: nowrap;
        }
        
        /* Footer */
        .policy-footer {
            background: #1a1a2e;
            color: rgba(255,255,255,0.6);
            text-align: center;
            padding: 12px 20px;
            font-size: 0.72rem;
        }
        
        .policy-footer strong {
            color: #DAA520;
        }
        
        .policy-footer .verify-code {
            color: rgba(255,255,255,0.7);
            font-family: monospace;
            letter-spacing: 2px;
            font-size: 0.7rem;
            margin-top: 4px;
        }
        
        /* Issue info */
        .issue-info {
            display: flex;
            justify-content: space-between;
            padding: 10px 40px;
            background: #fff;
            border-top: 1px solid #e9ecef;
            font-size: 0.78rem;
            color: #999;
            margin-top: auto;
        }
        
        /* Print controls */
        .print-controls {
            text-align: center;
            padding: 20px;
            background: #fff;
            max-width: 800px;
            margin: 0 auto 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .print-controls button, .print-controls a {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 25px;
            border: none;
            border-radius: 8px;
            font-family: 'Tajawal';
            font-weight: 600;
            font-size: 0.95rem;
            cursor: pointer;
            text-decoration: none;
            margin: 0 5px;
            transition: all 0.3s ease;
        }
        
        .btn-print {
            background: linear-gradient(135deg, #DAA520, #FFD700);
            color: #fff;
        }
        
        .btn-print:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(218,165,32,0.4);
        }
        
        .btn-back {
            background: #6c757d;
            color: #fff;
        }
        
        .btn-back:hover {
            background: #5a6268;
            color: #fff;
        }
        
        @page {
            size: A4;
            margin: 5mm;
        }
        
        @media print {
            body { background: #fff; }
            .print-controls { display: none !important; }
            .policy-container { box-shadow: none; margin: 0; max-width: 100%; min-height: 100vh; }
        }
        
        @media (max-width: 600px) {
            .policy-header { flex-direction: column; gap: 15px; padding: 20px; }
            .policy-body { padding: 20px; }
            .info-grid { grid-template-columns: 1fr; }
            .dates-section { flex-direction: column; }
            .info-item .label { min-width: 100px; font-size: 0.75rem; }
        }
    </style>
</head>
<body>

<!-- أزرار التحكم -->
<div class="print-controls no-print">
    <button class="btn-print" onclick="window.print()">
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M6 9V2h12v7"/><path d="M6 18H4a2 2 0 01-2-2v-5a2 2 0 012-2h16a2 2 0 012 2v5a2 2 0 01-2 2h-2"/><rect x="6" y="14" width="12" height="8"/></svg>
        طباعة البوليصة
    </button>
    <a href="contract_view.php?id=<?= $contract['id'] ?>" class="btn-back">
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 12H5M12 19l-7-7 7-7"/></svg>
        العودة للعقد
    </a>
</div>

<!-- البوليصة -->
<div class="policy-container" id="policyContent">
    <!-- Header -->
    <div class="policy-header">
        <div class="policy-logo">
            <?php if ($logoData): ?>
            <img src="<?= $logoData ?>" alt="Logo">
            <?php endif; ?>
        </div>
        <div class="policy-company">
            <h1>Prince VIP</h1>
            <h2>نظام إدارة وتصدير بوالص VIP</h2>
        </div>
        <div class="policy-number-box">
            <small>رقم البوليصة</small>
            <strong>POL-<?= $contract['contract_number'] ?></strong>
        </div>
    </div>
    
    <div class="gold-bar"></div>
    
    <!-- Title -->
    <div class="policy-title">
        <h3>بوليصة تأمين المركبات VIP</h3>
        <p>هذه الوثيقة تثبت تفاصيل عقد التأمين والاشتراك</p>
    </div>
    
    <div class="policy-body">
        <!-- بيانات العميل -->
        <div class="section-title">📋 بيانات العميل</div>
        <div class="info-grid">
            <div class="info-item info-full">
                <div class="label">الاسم الكامل</div>
                <div class="value" style="font-weight:700;"><?= clean($contract['client_name']) ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الهوية</div>
                <div class="value"><?= clean($contract['client_id_number']) ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الجوال</div>
                <div class="value"><?= clean($contract['client_phone']) ?></div>
            </div>
        </div>
        
        <!-- بيانات المركبة -->
        <div class="section-title">🚗 بيانات المركبة</div>
        <div class="info-grid">
            <div class="info-item">
                <div class="label">نوع النمرة</div>
                <div class="value"><?= clean($contract['plate_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم السيارة</div>
                <div class="value" style="font-weight:700;font-size:1rem;"><?= clean($contract['car_number'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">التصنيف</div>
                <div class="value"><?= clean($contract['classification'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع السيارة</div>
                <div class="value"><?= clean($contract['car_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">لون السيارة</div>
                <div class="value"><?= clean($contract['car_color'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">سنة الإنتاج</div>
                <div class="value"><?= $contract['production_year'] ?? '-' ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع الترخيص</div>
                <div class="value"><?= clean($contract['license_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">صفة الاستخدام</div>
                <div class="value"><?= clean($contract['usage_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">نوع التأمين</div>
                <div class="value" style="font-weight:700;color:#DAA520;"><?= clean($contract['insurance_type'] ?? '-') ?></div>
            </div>
            <div class="info-item">
                <div class="label">رقم الشاصي</div>
                <div class="value" style="font-family:monospace;letter-spacing:1px;"><?= clean($contract['chassis_number'] ?? '-') ?></div>
            </div>
            <?php if (!empty($contract['package_name'])): ?>
            <div class="info-item info-full">
                <div class="label">الحزمة</div>
                <div class="value" style="font-weight:700;color:#DAA520;"><?= clean($contract['package_name']) ?> (<?= $contract['package_type'] == 'commercial' ? 'تجاري' : 'خصوصي' ?>)</div>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- التواريخ -->
        <div class="section-title">📅 فترة الاشتراك</div>
        <div class="dates-section">
            <div class="date-box">
                <div class="date-label">تاريخ بداية الاشتراك</div>
                <div class="date-value"><?= $contract['start_date'] ?></div>
            </div>
            <div class="date-box">
                <div class="date-label">تاريخ انتهاء الاشتراك</div>
                <div class="date-value"><?= $contract['end_date'] ?></div>
            </div>
        </div>
        
        <?php if ($contract['notes']): ?>
        <div class="section-title" style="margin-top:8px;">📝 ملاحظات</div>
        <p style="color:#666;font-size:0.75rem;padding:6px 10px;background:#f8f9fa;border-radius:6px;"><?= nl2br(clean($contract['notes'])) ?></p>
        <?php endif; ?>
        
        <!-- ختم الشعار -->
        <div class="stamp-section">
            <div class="stamp-circle">
                <?php if ($logoData): ?>
                <img src="<?= $logoData ?>" alt="Prince VIP">
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- معلومات الإصدار -->
    <div class="issue-info">
        <span>تاريخ الإصدار: <?= date('Y/m/d H:i') ?></span>
        <span>الوكيل: <?= clean($contract['agent_name']) ?></span>
        <span>رقم العقد: <?= clean($contract['contract_number']) ?></span>
    </div>
    
    <!-- Footer -->
    <div class="policy-footer">
        <strong>Prince VIP System</strong> - نظام إدارة وتصدير بوالص VIP | 
        Powered by <strong>Leadership</strong> &copy; <?= date('Y') ?>
        <div class="verify-code">🔒 رمز التحقق الإلكتروني: <?= $verificationFormatted ?></div>
    </div>
</div>

<!-- صفحة 2: الإرشادات والشروط -->
<div class="policy-container" style="margin-top:30px;page-break-before:always;">
    
    <!-- Header -->
    <div class="policy-header">
        <div class="policy-logo">
            <?php if ($logoData): ?>
            <img src="<?= $logoData ?>" alt="Logo">
            <?php endif; ?>
        </div>
        <div class="policy-company">
            <h1>Prince VIP</h1>
            <h2>التغطيات والشروط والإرشادات</h2>
        </div>
        <div class="policy-number-box">
            <small>رقم البوليصة</small>
            <strong>POL-<?= $contract['contract_number'] ?></strong>
        </div>
    </div>
    <div class="gold-bar"></div>
    
    <div class="policy-body" style="position:relative;min-height:auto;">
        <!-- Watermark -->
        <?php if ($logoData): ?>
        <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);opacity:0.06;pointer-events:none;z-index:0;">
            <img src="<?= $logoData ?>" style="width:350px;height:auto;">
        </div>
        <?php endif; ?>
        
        <div style="position:relative;z-index:1;">
            <!-- التغطيات -->
            <div class="section-title" style="margin-top:5px;">🛡️ التغطيات</div>
            <ol style="font-size:0.78rem;color:#444;line-height:2;padding-right:20px;margin-bottom:15px;">
                <li>دفع مبلغ الاشتراك يعني تصريح المشترك بأنه قرأ ووافق على كلية الخدمة والموافقة على الشروط كاملة تكون الخدمة سارية المفعول بعد (7) أيام من تاريخ بداية الاشتراك في حال استوفي جميع الشروط.</li>
                <li>الخدمة للمركبة حسب تسجيلها برخصة المركبة وأي خطأ في إدخال بيانات المركبة تكون الخدمة لاغية.</li>
                <li>أن تكون المدة الخدمة اللذي (90) يوماً.</li>
                <li>يحق للمشترك إلغاء الاشتراك الـ (VIP) خلال 14 يوم من تاريخ الإصدار واسترجاع كامل المبلغ وذلك في حال عدم الحصول على أي خدمة.</li>
                <li>في حال القطعات والمرايا يكون سقف التغطية بحد أعلى 4000 شيكل وتحمل 120.</li>
                <li>توفر مركبة بديلة لـيون (عتعرا) من اليوم التالي للتبليغ عن الحادث وبحد أقصى (7) أيام ولمرة واحدة خلال السنة.</li>
                <li>شرط وجود ترخيص وتأمين ساري المفعول.</li>
                <li>تغطية حوادث كسر الزجاج: شركة إيت تاك غير ملزمة بتوفير زجاج أصلي ويتم توفير الزجاج الحاصل على المواصفات الأوروبية.</li>
                <li>هذه السقف لا تعلم من ثمن الزجاج الشامل بالتغطية.</li>
            </ol>
            
            <!-- الشروط والاستثناءات -->
            <div class="section-title">⚠️ الشروط والإستثناءات والتحملات</div>
            <ol style="font-size:0.78rem;color:#444;line-height:2;padding-right:20px;margin-bottom:15px;">
                <li>شركة إيت تاك غير ملزمة بالتغطية إذا لم يتم التبليغ عن الضرر بعد <strong style="color:red;">12</strong> يوم من تاريخ الحادث.</li>
                <li>خدمة الونش والمركبة البديلة لا تشمل المركبات بعمر <strong style="color:red;">15</strong> سنة فأكثر.</li>
                <li>جزء المركبة مقصود لا تكون على شارع معبد واسفلت طرق اراضي وأن لا تكون في موقف حدث الأرض وان تكون قريبة على <u>4 عجلات</u>.</li>
                <li>تقدم الخدمات في المحلات التي يتم اختيارها عقط من شركة بيت تاك.</li>
                <li>يشترط معاينة الزجاج من قبل أحد مراكز الخدمة المعتمدة وإذا لم تتم المعاينة فإن الشركة غير ملزمة بقياس الزجاج.</li>
                <li>لا يتم استبدال الزجاج في حالةت العنف أو الشغب.</li>
                <li>تكون المركبة البديلة (المستأجرة) حسب المتوفر لدى مكاتب تأجير المركبات من فئة B.</li>
                <li>في حال عدم القدرة على توفير المركبة البديلة يتم الدفع الليون مبلغ <strong style="color:red;">120</strong> شيكل غير شامل الضريبة بدل إيجار يومياً للمركبة.</li>
                <li>يشترط بالمركبة البديلة أن يكون عمر المستأجر أكثر من 24 سنة وأحياناً معافى من الأولى استلم المركبة.</li>
                <li>عند طلب الخدمة (المستأجر للمركبة) مسؤولية كل ما يرد عليها من رسوم جولات ومسلوكيات وهكذا وكل ما يتعلق بالسيارة.</li>
                <li>في حال المركبة تجارية يكون التحمل على الزجاج (%20) بحد أدنى 150 شيكل.</li>
                <li>شركة إيت تاك لخدمات المركبات على الطريق تختص بالحق في إنهاء مدة الاشتراك أو تعديل شروط الخدمة في أي وقت بدون أن تكون ملزمة في تقدم مبررات وذلك بعدما يتم تقديم بلغ من قبل الشركة إلي الوكلاء المشتركين بالتاكسي أو البريد الإلكتروني.</li>
            </ol>
        </div>
    </div>
    
    <!-- معلومات الإصدار -->
    <div class="issue-info">
        <span>تاريخ الإصدار: <?= date('Y/m/d H:i') ?></span>
        <span>الوكيل: <?= clean($contract['agent_name']) ?></span>
        <span>رقم العقد: <?= clean($contract['contract_number']) ?></span>
    </div>
    
    <div class="policy-footer">
        <strong>Prince VIP System</strong> - نظام إدارة وتصدير بوالص VIP | 
        Powered by <strong>Leadership</strong> &copy; <?= date('Y') ?>
        <div class="verify-code">🔒 رمز التحقق الإلكتروني: <?= $verificationFormatted ?></div>
    </div>
</div>

</body>
</html>
