<?php
/**
 * Prince VIP System - Settings (Admin Only)
 * الإعدادات والقوائم المنسدلة
 */
$pageTitle = 'الإعدادات';
require_once 'includes/header.php';
if (!isAdmin()) { redirect('dashboard.php'); }
$db = getDB();

$categories = [
    'plate_type' => 'أنواع نمر السيارات',
    'classification' => 'التصنيفات',
    'car_type' => 'أنواع المركبات',
    'usage_type' => 'صفة الاستخدام',
    'insurance_type' => 'نوع التأمين',
    'license_type' => 'نوع الترخيص'
];
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1"><i class="fas fa-cog text-primary me-2"></i>إعدادات النظام</h4>
        <p class="text-muted small mb-0">إدارة القوائم المنسدلة والخيارات</p>
    </div>
</div>

<div class="row">
    <?php foreach ($categories as $catKey => $catLabel): ?>
    <?php
    $opts = $db->prepare("SELECT * FROM settings_options WHERE category = ? ORDER BY sort_order");
    $opts->execute([$catKey]);
    $options = $opts->fetchAll();
    ?>
    <div class="col-lg-6 mb-4">
        <div class="content-card">
            <div class="card-header">
                <h5><i class="fas fa-list text-primary"></i> <?= $catLabel ?></h5>
                <button class="btn btn-sm btn-gold" onclick="addOption('<?= $catKey ?>', '<?= $catLabel ?>')">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>القيمة</th>
                                <th>الترتيب</th>
                                <th>الحالة</th>
                                <th>إجراءات</th>
                            </tr>
                        </thead>
                        <tbody id="cat_<?= $catKey ?>">
                            <?php foreach ($options as $opt): ?>
                            <tr>
                                <td><?= clean($opt['option_value']) ?></td>
                                <td><?= $opt['sort_order'] ?></td>
                                <td>
                                    <?php if ($opt['is_active']): ?>
                                    <span class="status-badge active">فعال</span>
                                    <?php else: ?>
                                    <span class="status-badge draft">معطل</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-gold" onclick="editOption(<?= $opt['id'] ?>, '<?= clean($opt['option_value']) ?>', <?= $opt['sort_order'] ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <?php if ($opt['is_active']): ?>
                                    <button class="btn btn-sm btn-outline-danger" onclick="toggleOption(<?= $opt['id'] ?>, 0)">
                                        <i class="fas fa-eye-slash"></i>
                                    </button>
                                    <?php else: ?>
                                    <button class="btn btn-sm btn-outline-success" onclick="toggleOption(<?= $opt['id'] ?>, 1)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- مودال إضافة/تعديل خيار -->
<div class="modal fade" id="optionModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="optionModalTitle">إضافة خيار</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="optId">
                <input type="hidden" id="optCategory">
                <div class="form-group">
                    <label>القيمة <span class="required">*</span></label>
                    <input type="text" id="optValue" class="form-control" required>
                </div>
                <div class="form-group mb-0">
                    <label>الترتيب</label>
                    <input type="number" id="optOrder" class="form-control" value="0">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" id="saveOption" class="btn btn-gold">حفظ</button>
            </div>
        </div>
    </div>
</div>

<?php
$extraJS = <<<'JS'
<script>
function addOption(category, label) {
    $('#optionModalTitle').text('إضافة خيار - ' + label);
    $('#optId').val('');
    $('#optCategory').val(category);
    $('#optValue').val('');
    $('#optOrder').val(0);
    new bootstrap.Modal('#optionModal').show();
}

function editOption(id, value, order) {
    $('#optionModalTitle').text('تعديل خيار');
    $('#optId').val(id);
    $('#optValue').val(value);
    $('#optOrder').val(order);
    new bootstrap.Modal('#optionModal').show();
}

$('#saveOption').on('click', function() {
    const id = $('#optId').val();
    const data = {
        action: id ? 'update' : 'create',
        id: id,
        category: $('#optCategory').val(),
        option_value: $('#optValue').val(),
        sort_order: $('#optOrder').val()
    };
    ajaxRequest('ajax/settings.php', data, function(r) {
        if (r.success) { showAlert(r.message, 'success'); setTimeout(() => location.reload(), 800); }
        else showAlert(r.message, 'danger');
    });
});

function toggleOption(id, active) {
    ajaxRequest('ajax/settings.php', {action:'toggle', id: id, is_active: active}, function(r) {
        if (r.success) { showAlert(r.message, 'success'); setTimeout(() => location.reload(), 800); }
        else showAlert(r.message, 'danger');
    });
}
</script>
JS;

require_once 'includes/footer.php';
?>
